<?php


namespace App\Packages\AdvanceSearch\Trait;

trait  AdminMenuWithRoutesTrait
{

    public function getAdminMenuWithRoutes()
    {
        $allRoutes = $this->adminMenuWithRoutes();
        if (auth('admin')->user()->admin_role_id == 1) {
            return $allRoutes;
        }

        $user_role = auth('admin')->user()->role;
        $permission = json_decode($user_role->module_access, true);
       return  collect($allRoutes)->filter(function($item) use($permission){
            return $item['module'] == '' || in_array($item['module'], $permission);
        })->values()->toArray();
    }

    public function adminMenuWithRoutes()
    {
      $result =  [
            [
                "page_title" => 'dashboard',
                "uri" => 'admin/dashboard',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kYXNoYm9hcmQ=',
                "uri_count" => '2',
                "method" => 'GET',
                "keywords" => 'Dashboard',
                "type" => 'menu',
                "module" => '',
                "priority" => '1',
                "page_title_value" => 'dashboard',
            ],
            [
                "page_title" => 'POS',
                "uri" => 'admin/pos',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wb3M=',
                "uri_count" => '2',
                "method" => 'GET',
                "keywords" => 'POS',
                "type" => 'menu',
                "module" => 'pos_management',
                "priority" => '1',
                "page_title_value" => 'POS',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/all',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9hbGw=',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'orders, all',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/pending',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9wZW5kaW5n',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'pending, pending orders',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/confirmed',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9jb25maXJtZWQ=',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'confirmed',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/processing',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9wcm9jZXNzaW5n',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'processing, packaging',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/out_for_delivery',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9vdXRfZm9yX2RlbGl2ZXJ5',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'out for delivery, delivery',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/delivered',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9kZWxpdmVyZWQ=',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'delivered',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/returned',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9yZXR1cm5lZA==',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'returned',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/failed',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9mYWlsZWQ=',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'failed',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'orders',
                "uri" => 'admin/orders/list/canceled',
                "key" => 'ZGJzZWFyY2hhZG1pbi9vcmRlcnMvbGlzdC9jYW5jZWxlZA==',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'canceled',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'orders',
            ],
            [
                "page_title" => 'refund_Requests',
                "uri" => 'admin/refund-section/refund/list/pending',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZWZ1bmQtc2VjdGlvbi9yZWZ1bmQvbGlzdC9wZW5kaW5n',
                "uri_count" => '5',
                "method" => 'GET',
                "keywords" => 'refund Requests,pending',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'refund_Requests',
            ],
            [
                "page_title" => 'refund_Requests',
                "uri" => 'admin/refund-section/refund/list/approved',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZWZ1bmQtc2VjdGlvbi9yZWZ1bmQvbGlzdC9hcHByb3ZlZA==',
                "uri_count" => '5',
                "method" => 'GET',
                "keywords" => 'approved',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'refund_Requests',
            ],
            [
                "page_title" => 'refund_Requests',
                "uri" => 'admin/refund-section/refund/list/refunded',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZWZ1bmQtc2VjdGlvbi9yZWZ1bmQvbGlzdC9yZWZ1bmRlZA==',
                "uri_count" => '5',
                "method" => 'GET',
                "keywords" => 'refund Requests,refunded',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'refund_Requests',
            ],
            [
                "page_title" => 'refund_Requests',
                "uri" => 'admin/refund-section/refund/list/rejected',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZWZ1bmQtc2VjdGlvbi9yZWZ1bmQvbGlzdC9yZWplY3RlZA==',
                "uri_count" => '5',
                "method" => 'GET',
                "keywords" => 'refund Requests,rejected',
                "type" => 'menu',
                "module" => 'order_management',
                "priority" => '1',
                "page_title_value" => 'refund_Requests',
            ],
            [
                "page_title" => 'Category',
                "uri" => 'admin/category/view',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jYXRlZ29yeS92aWV3',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'categories',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Category',
            ],
            [
                "page_title" => 'Sub_Category',
                "uri" => 'admin/sub-category/view',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zdWItY2F0ZWdvcnkvdmlldw==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'sub categories, sub category setup',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Sub_Category',
            ],
            [
                "page_title" => 'Sub_sub_Category',
                "uri" => 'admin/sub-sub-category/view',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zdWItc3ViLWNhdGVnb3J5L3ZpZXc=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'sub sub categories, sub sub category setup',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Sub_sub_Category',
            ],
            [
                "page_title" => 'Brands',
                "uri" => 'admin/brand/add-new',
                "key" => 'ZGJzZWFyY2hhZG1pbi9icmFuZC9hZGQtbmV3',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'add new brand, brand add, Brand Setup',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Brands',
            ],
            [
                "page_title" => 'Brands',
                "uri" => 'admin/brand/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9icmFuZC9saXN0',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'brands list, brand list',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Brands',
            ],
            [
                "page_title" => 'product_Attribute_Setup',
                "uri" => 'admin/attribute/view',
                "key" => 'ZGJzZWFyY2hhZG1pbi9hdHRyaWJ1dGUvdmlldw==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'product Attribute Setup',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'product_Attribute_Setup',
            ],
            [
                "page_title" => 'In_House_Products',
                "uri" => 'admin/products/list/in-house',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9saXN0L2luLWhvdXNl',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'In House Products, product list',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'In_House_Products',
            ],
            [
                "page_title" => 'Add_New_Product',
                "uri" => 'admin/products/add',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9hZGQ=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Add New Product, product add, add product',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Add_New_Product',
            ],
            [
                "page_title" => 'bulk_import',
                "uri" => 'admin/products/bulk-import',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9idWxrLWltcG9ydA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'bulk import, product bulk import',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'bulk_import',
            ],
            [
                "page_title" => 'Request_Restock_List',
                "uri" => 'admin/products/request-restock-list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9yZXF1ZXN0LXJlc3RvY2stbGlzdA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Request Restock List, Request Restock, Restock List',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Request_Restock_List',
            ],
            [
                "page_title" => 'vendor_Products',
                "uri" => 'admin/products/updated-product-list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy91cGRhdGVkLXByb2R1Y3QtbGlzdA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'vendor Products list,vendor products, products list',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'vendor_Products',
            ],
            [
                "page_title" => 'vendor_Products',
                "uri" => 'admin/products/list/vendor?request_status=0',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9saXN0L3ZlbmRvcj9yZXF1ZXN0X3N0YXR1cz0w',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'vendor product request, product request',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'vendor_Products',
            ],
            [
                "page_title" => 'vendor_Products',
                "uri" => 'admin/products/list/vendor?request_status=1',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9saXN0L3ZlbmRvcj9yZXF1ZXN0X3N0YXR1cz0x',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'vendor approved products list, approved products,vendor approved products',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'vendor_Products',
            ],
            [
                "page_title" => 'vendor_Products',
                "uri" => 'admin/products/list/vendor?request_status=2',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9saXN0L3ZlbmRvcj9yZXF1ZXN0X3N0YXR1cz0y',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'vendor denied products list, denied products,vendor denied products',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'vendor_Products',
            ],
            [
                "page_title" => 'Update_product',
                "uri" => 'admin/products/updated-product-list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy91cGRhdGVkLXByb2R1Y3QtbGlzdA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'product update request, vendor product update,vendor update products, update product',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'Update_product',
            ],
            [
                "page_title" => 'product_gallery',
                "uri" => 'admin/products/product-gallery',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wcm9kdWN0cy9wcm9kdWN0LWdhbGxlcnk=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'product gallery, gallery',
                "type" => 'menu',
                "module" => 'product_management',
                "priority" => '1',
                "page_title_value" => 'product_gallery',
            ],
            [
                "page_title" => 'banner_Setup',
                "uri" => 'admin/banner/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9iYW5uZXIvbGlzdA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'banner Setup, setup banner',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'banner_Setup',
            ],
            [
                "page_title" => 'Coupon_Setup',
                "uri" => 'admin/coupon/add',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jb3Vwb24vYWRk',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Coupon setup, setup coupon, add coupon, coupon add',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Coupon_Setup',
            ],
            [
                "page_title" => 'Flash Deals',
                "uri" => 'admin/deal/flash',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWFsL2ZsYXNo',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'flash deal',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Flash Deals',
            ],
            [
                "page_title" => 'Deal_of_the_day',
                "uri" => 'admin/deal/day',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWFsL2RheQ==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Deal of the day',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Deal_of_the_day',
            ],
            [
                "page_title" => 'Feature_deal',
                "uri" => 'admin/deal/feature',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWFsL2ZlYXR1cmU=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Feature deal, deal feature',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Feature_deal',
            ],
            [
                "page_title" => 'Clearance_Sale',
                "uri" => 'admin/deal/clearance-sale',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWFsL2NsZWFyYW5jZS1zYWxl',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Clearance Sale, sale, clearance',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Clearance_Sale',
            ],
            [
                "page_title" => 'notifications',
                "uri" => 'admin/notification/index',
                "key" => 'ZGJzZWFyY2hhZG1pbi9ub3RpZmljYXRpb24vaW5kZXg=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'notifications, send notification',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'notifications',
            ],
            [
                "page_title" => 'Notification_Messages',
                "uri" => 'admin/push-notification/index',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wdXNoLW5vdGlmaWNhdGlvbi9pbmRleA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Notification Messages, Notification',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Notification_Messages',
            ],
            [
                "page_title" => 'announcement',
                "uri" => 'admin/business-settings/announcement',
                "key" => 'ZGJzZWFyY2hhZG1pbi9idXNpbmVzcy1zZXR0aW5ncy9hbm5vdW5jZW1lbnQ=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'announcement',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'announcement',
            ],
            [
                "page_title" => 'Inbox',
                "uri" => 'admin/messages/index/customer',
                "key" => 'ZGJzZWFyY2hhZG1pbi9tZXNzYWdlcy9pbmRleC9jdXN0b21lcg==',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Chatting List, Inbox',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Inbox',
            ],
            [
                "page_title" => 'Messages',
                "uri" => 'admin/contact/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jb250YWN0L2xpc3Q=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Customer message, messages',
                "type" => 'menu',
                "module" => 'help_and_support',
                "priority" => '1',
                "page_title_value" => 'Messages',
            ],
            [
                "page_title" => 'support_Ticket',
                "uri" => 'admin/support-ticket/view',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zdXBwb3J0LXRpY2tldC92aWV3',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'support Ticket, ticket',
                "type" => 'menu',
                "module" => 'help_and_support',
                "priority" => '1',
                "page_title_value" => 'support_Ticket',
            ],
            [
                "page_title" => 'sales_and_Transaction_Report',
                "uri" => 'admin/report/admin-earning',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZXBvcnQvYWRtaW4tZWFybmluZw==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Earning Reports, sales and Transaction Report,Transaction Report, sales report',
                "type" => 'menu',
                "module" => 'report',
                "priority" => '1',
                "page_title_value" => 'sales_and_Transaction_Report',
            ],
            [
                "page_title" => 'Inhouse_sale',
                "uri" => 'admin/report/inhouse-product-sale',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZXBvcnQvaW5ob3VzZS1wcm9kdWN0LXNhbGU=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Inhouse sale, Inhouse sales, Sales',
                "type" => 'menu',
                "module" => 'report',
                "priority" => '1',
                "page_title_value" => 'Inhouse_sale',
            ],
            [
                "page_title" => 'Vendor_Sales',
                "uri" => 'admin/report/vendor-report',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZXBvcnQvdmVuZG9yLXJlcG9ydA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Vendor Reports, vendor sales, vendor sale',
                "type" => 'menu',
                "module" => 'report',
                "priority" => '1',
                "page_title_value" => 'Vendor_Sales',
            ],
            [
                "page_title" => 'Transaction_report',
                "uri" => 'admin/transaction/order-transaction-list',
                "key" => 'ZGJzZWFyY2hhZG1pbi90cmFuc2FjdGlvbi9vcmRlci10cmFuc2FjdGlvbi1saXN0',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Transaction report, report',
                "type" => 'menu',
                "module" => 'report',
                "priority" => '1',
                "page_title_value" => 'Transaction_report',
            ],
            [
                "page_title" => 'product_Report',
                "uri" => 'admin/report/all-product',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZXBvcnQvYWxsLXByb2R1Y3Q=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'product Report, report, report product',
                "type" => 'menu',
                "module" => 'report',
                "priority" => '1',
                "page_title_value" => 'product_Report',
            ],
            [
                "page_title" => 'order_Report',
                "uri" => 'admin/report/order',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZXBvcnQvb3JkZXI=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'order Report, report order, report',
                "type" => 'menu',
                "module" => 'report',
                "priority" => '1',
                "page_title_value" => 'order_Report',
            ],
            [
                "page_title" => 'Blog_management',
                "uri" => 'admin/blog/view',
                "key" => 'ZGJzZWFyY2hhZG1pbi9ibG9nL3ZpZXc=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Blog management, Blog , blog list',
                "type" => 'menu',
                "module" => 'blog_management',
                "priority" => '1',
                "page_title_value" => 'Blog_management',
            ],
            [
                "page_title" => 'Add_Blog',
                "uri" => 'admin/blog/add',
                "key" => 'ZGJzZWFyY2hhZG1pbi9ibG9nL2FkZA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'add blog, create new blog, blog add',
                "type" => 'menu',
                "module" => 'blog_management',
                "priority" => '1',
                "page_title_value" => 'Add_Blog',
            ],
            [
                "page_title" => 'customer_List',
                "uri" => 'admin/customer/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jdXN0b21lci9saXN0',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'customer List',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'customer_List',
            ],
            [
                "page_title" => 'Customer_reviews',
                "uri" => 'admin/reviews/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9yZXZpZXdzL2xpc3Q=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Customer reviews, reviews',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Customer_reviews',
            ],
            [
                "page_title" => 'Wallet',
                "uri" => 'admin/customer/wallet/report',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jdXN0b21lci93YWxsZXQvcmVwb3J0',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Customer wallet, wallet, wallet report',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Wallet',
            ],
            [
                "page_title" => 'Wallet_bonus_setup',
                "uri" => 'admin/customer/wallet/bonus-setup',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jdXN0b21lci93YWxsZXQvYm9udXMtc2V0dXA=',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Wallet bonus setup, wallet, bonus setup',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Wallet_bonus_setup',
            ],
            [
                "page_title" => 'loyalty_points',
                "uri" => 'admin/customer/loyalty/report',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jdXN0b21lci9sb3lhbHR5L3JlcG9ydA==',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'loyalty point report, loyalty point ',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'loyalty_points',
            ],
            [
                "page_title" => 'vendor_List',
                "uri" => 'admin/vendors/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi92ZW5kb3JzL2xpc3Q=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'vendor List',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'vendor_List',
            ],
            [
                "page_title" => 'add_new_Vendor',
                "uri" => 'admin/vendors/add',
                "key" => 'ZGJzZWFyY2hhZG1pbi92ZW5kb3JzL2FkZA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'add new vendor, add vendor',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'add_new_Vendor',
            ],
            [
                "page_title" => 'add_new_Vendor',
                "uri" => 'admin/vendors/add',
                "key" => 'ZGJzZWFyY2hhZG1pbi92ZW5kb3JzL2FkZA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'add new vendor, add vendor',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'add_new_Vendor',
            ],
            [
                "page_title" => 'Withdraws',
                "uri" => 'admin/vendors/withdraw-list',
                "key" => 'ZGJzZWFyY2hhZG1pbi92ZW5kb3JzL3dpdGhkcmF3LWxpc3Q=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Withdraws, Withdraw request',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Withdraws',
            ],
            [
                "page_title" => 'Withdraw_method_list',
                "uri" => 'admin/vendors/withdraw-method/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi92ZW5kb3JzL3dpdGhkcmF3LW1ldGhvZC9saXN0',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Withdraw method list',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Withdraw_method_list',
            ],
            [
                "page_title" => 'delivery_men',
                "uri" => 'admin/delivery-man/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWxpdmVyeS1tYW4vbGlzdA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'delivery men',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'delivery_men',
            ],
            [
                "page_title" => 'Add_new',
                "uri" => 'admin/delivery-man/add',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWxpdmVyeS1tYW4vYWRk',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Add new delivery man',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Add_new',
            ],
            [
                "page_title" => 'Withdraws',
                "uri" => 'admin/delivery-man/withdraw-list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWxpdmVyeS1tYW4vd2l0aGRyYXctbGlzdA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'withdraw list, withdraw request, delivery man withdraw request list',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Withdraws',
            ],
            [
                "page_title" => 'Emergency_contact',
                "uri" => 'admin/delivery-man/emergency-contact',
                "key" => 'ZGJzZWFyY2hhZG1pbi9kZWxpdmVyeS1tYW4vZW1lcmdlbmN5LWNvbnRhY3Q=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Emergency contact, delivery man Emergency contact',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Emergency_contact',
            ],
            [
                "page_title" => 'Employee_role_setup',
                "uri" => 'admin/custom-role/add',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jdXN0b20tcm9sZS9hZGQ=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Employee role setup, Employee role',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'Employee_role_setup',
            ],
            [
                "page_title" => 'employees',
                "uri" => 'admin/employee/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9lbXBsb3llZS9saXN0',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'employees,employee list',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'employees',
            ],
            [
                "page_title" => 'subscribers',
                "uri" => 'admin/customer/subscriber-list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9jdXN0b21lci9zdWJzY3JpYmVyLWxpc3Q=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'subscribers',
                "type" => 'menu',
                "module" => 'user_section',
                "priority" => '1',
                "page_title_value" => 'subscribers',
            ],
            [
                "page_title" => 'Business_Setup',
                "uri" => 'admin/business-settings/web-config',
                "key" => 'ZGJzZWFyY2hhZG1pbi9idXNpbmVzcy1zZXR0aW5ncy93ZWItY29uZmln',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Business Setup',
                "type" => 'menu',
                "module" => 'business_settings',
                "priority" => '1',
                "page_title_value" => 'Business_Setup',
            ],
            [
                "page_title" => 'Inhouse_Shop',
                "uri" => 'admin/business-settings/inhouse-shop',
                "key" => 'ZGJzZWFyY2hhZG1pbi9idXNpbmVzcy1zZXR0aW5ncy9pbmhvdXNlLXNob3A=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Inhouse Shop',
                "type" => 'menu',
                "module" => 'business_settings',
                "priority" => '1',
                "page_title_value" => 'Inhouse_Shop',
            ],
            [
                "page_title" => 'SEO_Settings',
                "uri" => 'admin/seo-settings/web-master-tool',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zZW8tc2V0dGluZ3Mvd2ViLW1hc3Rlci10b29s',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'SEO Settings',
                "type" => 'menu',
                "module" => 'business_settings',
                "priority" => '1',
                "page_title_value" => 'SEO_Settings',
            ],
            [
                "page_title" => 'Priority_Setup',
                "uri" => 'admin/business-settings/priority-setup',
                "key" => 'ZGJzZWFyY2hhZG1pbi9idXNpbmVzcy1zZXR0aW5ncy9wcmlvcml0eS1zZXR1cA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Priority Setup',
                "type" => 'menu',
                "module" => 'promotion_management',
                "priority" => '1',
                "page_title_value" => 'Priority_Setup',
            ],
            [
                "page_title" => 'Pages_and_Media',
                "uri" => 'admin/pages-and-media/list',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wYWdlcy1hbmQtbWVkaWEvbGlzdA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Pages And Media, Business pages',
                "type" => 'menu',
                "module" => 'business_settings',
                "priority" => '1',
                "page_title_value" => 'Pages_and_Media',
            ],
            [
                "page_title" => 'Social_media_links',
                "uri" => 'admin/pages-and-media/social-media',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wYWdlcy1hbmQtbWVkaWEvc29jaWFsLW1lZGlh',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Social Media, Social media link',
                "type" => 'menu',
                "module" => 'system_settings',
                "priority" => '1',
                "page_title_value" => 'Social_media_links',
            ],
            [
                "page_title" => 'Vendor_registration',
                "uri" => 'admin/pages-and-media/vendor-registration-settings/index',
                "key" => 'ZGJzZWFyY2hhZG1pbi9wYWdlcy1hbmQtbWVkaWEvdmVuZG9yLXJlZ2lzdHJhdGlvbi1zZXR0aW5ncy9pbmRleA==',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Vendor registration',
                "type" => 'menu',
                "module" => 'system_settings',
                "priority" => '1',
                "page_title_value" => 'Vendor_registration',
            ],
            [
                "page_title" => 'System_Setup',
                "uri" => 'admin/system-setup/environment-setup',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zeXN0ZW0tc2V0dXAvZW52aXJvbm1lbnQtc2V0dXA=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'System Setup',
                "type" => 'menu',
                "module" => 'system_settings',
                "priority" => '1',
                "page_title_value" => 'System_Setup',
            ],
            [
                "page_title" => 'Login_Settings',
                "uri" => 'admin/system-setup/login-settings/customer-login-setup',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zeXN0ZW0tc2V0dXAvbG9naW4tc2V0dGluZ3MvY3VzdG9tZXItbG9naW4tc2V0dXA=',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Login Settings',
                "type" => 'menu',
                "module" => 'system_settings',
                "priority" => '1',
                "page_title_value" => 'Login_Settings',
            ],
            [
                "page_title" => 'Email_Template',
                "uri" => 'admin/system-setup/email-templates/admin/order-received',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zeXN0ZW0tc2V0dXAvZW1haWwtdGVtcGxhdGVzL2FkbWluL29yZGVyLXJlY2VpdmVk',
                "uri_count" => '5',
                "method" => 'GET',
                "keywords" => 'Email Template',
                "type" => 'menu',
                "module" => 'system_settings',
                "priority" => '1',
                "page_title_value" => 'Email_Template',
            ],
            [
                "page_title" => 'Gallery',
                "uri" => 'admin/system-setup/file-manager/index',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zeXN0ZW0tc2V0dXAvZmlsZS1tYW5hZ2VyL2luZGV4',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Gallery',
                "type" => 'menu',
                "module" => 'system_settings',
                "priority" => '1',
                "page_title_value" => 'Gallery',
            ],
            [
                "page_title" => 'Payment_Methods',
                "uri" => 'admin/third-party/payment-method',
                "key" => 'ZGJzZWFyY2hhZG1pbi90aGlyZC1wYXJ0eS9wYXltZW50LW1ldGhvZA==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Payment Methods',
                "type" => 'menu',
                "module" => '3rd_party_setup',
                "priority" => '1',
                "page_title_value" => 'Payment_Methods',
            ],
            [
                "page_title" => 'Firebase',
                "uri" => 'admin/third-party/firebase-configuration/setup',
                "key" => 'ZGJzZWFyY2hhZG1pbi90aGlyZC1wYXJ0eS9maXJlYmFzZS1jb25maWd1cmF0aW9uL3NldHVw',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Firebase',
                "type" => 'menu',
                "module" => '3rd_party_setup',
                "priority" => '1',
                "page_title_value" => 'Firebase',
            ],
            [
                "page_title" => 'Marketing_Tools',
                "uri" => 'admin/third-party/analytics-index',
                "key" => 'ZGJzZWFyY2hhZG1pbi90aGlyZC1wYXJ0eS9hbmFseXRpY3MtaW5kZXg=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'Marketing Tools',
                "type" => 'menu',
                "module" => '3rd_party_setup',
                "priority" => '1',
                "page_title_value" => 'Marketing_Tools',
            ],
            [
                "page_title" => 'Other_Configuration',
                "uri" => 'admin/third-party/social-login/view',
                "key" => 'ZGJzZWFyY2hhZG1pbi90aGlyZC1wYXJ0eS9zb2NpYWwtbG9naW4vdmlldw==',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Other Configuration',
                "type" => 'menu',
                "module" => '3rd_party_setup',
                "priority" => '1',
                "page_title_value" => 'Other_Configuration',
            ],
            [
                "page_title" => 'Theme_Setup',
                "uri" => 'admin/system-setup/theme/setup',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zeXN0ZW0tc2V0dXAvdGhlbWUvc2V0dXA=',
                "uri_count" => '4',
                "method" => 'GET',
                "keywords" => 'Theme Setup',
                "type" => 'menu',
                "module" => 'themes_and_addons',
                "priority" => '1',
                "page_title_value" => 'Theme_Setup',
            ],
            [
                "page_title" => 'System_Addons',
                "uri" => 'admin/system-setup/addon',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zeXN0ZW0tc2V0dXAvYWRkb24=',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'System Addons',
                "type" => 'menu',
                "module" => 'themes_and_addons',
                "priority" => '1',
                "page_title_value" => 'System_Addons',
            ],
            [
                "page_title" => 'Addon_Activation',
                "uri" => 'admin/system-setup/addon-activation',
                "key" => 'ZGJzZWFyY2hhZG1pbi9zeXN0ZW0tc2V0dXAvYWRkb24tYWN0aXZhdGlvbg==',
                "uri_count" => '3',
                "method" => 'GET',
                "keywords" => 'System Addons',
                "type" => 'menu',
                "module" => 'themes_and_addons',
                "priority" => '1',
                "page_title_value" => 'Addon_Activation',
            ]
        ];

        $asterThemeRoutes = [];
        if (theme_root_path() == 'theme_aster') {
            $asterThemeRoutes = [
                [
                    "page_title" => 'Promotional_banners',
                    "uri" => 'admin/banner/list',
                    "key" => "YWRtaW4vYmFubmVyL2xpc3Q=",
                    "uri_count" => '2',
                    "method" => 'GET',
                    "keywords" => 'Promotional banners, Promotional',
                    "type" => 'menu',
                    "module" => 'aster_menu',
                    "priority" => '1',
                    "page_title_value" => 'Promotional_banners',
                ],
                [
                    "page_title" => 'In_house_store_banner',
                    "uri" => 'admin/business-settings/inhouse-shop?action=edit',
                    "key" => 'YWRtaW4vYnVzaW5lc3Mtc2V0dGluZ3MvaW5ob3VzZS1zaG9wP2FjdGlvbj1lZGl0',
                    "uri_count" => '2',
                    "method" => 'GET',
                    "keywords" => 'in house store banner , store banner',
                    "type" => 'menu',
                    "module" => 'aster_menu',
                    "priority" => '1',
                    "page_title_value" => 'Promotional_banners',
                ],
            ];
            if (!empty($asterThemeRoutes)) {
                $result = array_merge($result, $asterThemeRoutes);
            }
        }
        return $result;
    }
}
